class Sirius extends xDeathMatch;

#exec AUDIO IMPORT FILE="..\Sounds\Sirius\MissionAccomplished.wav" NAME="MissionAccomplished" GROUP="Mission"
#exec AUDIO IMPORT FILE="..\Sounds\Sirius\MissionFailed.wav" NAME="MissionFailed" GROUP="Mission"

var bool bGoalReached;
var sound EndGameSound[2];
var(LoadingHints) private localized array<string> SiriusHints;

function bool AddBot(optional string botName)
{
    return true;
}

function SetPlayerDefaults(Pawn PlayerPawn)
{
	Super.SetPlayerDefaults(PlayerPawn);
	Remmy(PlayerPawn).SetSiriusMesh();
	xPawn(PlayerPawn).bFrozenBody=false;
	ChangeName(PlayerPawn.Controller, default.DefaultPlayerName, false );
}

function PlayEndOfMatchMessage()
{
	local controller C;
	for ( C = Level.ControllerList; C != None; C = C.NextController )
	{
		if ( C.IsA('RemmyController') )
		{
			if (bGoalReached)
				PlayerController(C).PlayAnnouncement(EndGameSound[0],1,true);
				//PlayerController(C).ClientPlaySound(Sound'zwolf.Mission.MissionAccomplished');
			else
				PlayerController(C).PlayAnnouncement(EndGameSound[1],1,true);
				//PlayerController(C).ClientPlaySound(Sound'zwolf.Mission.MissionFailed');
		}
	}
}

static function string GetNextLoadHint( string MapName )
{
	local array<string> Hints;

	Hints = GetAllLoadHints(true);

	if ( Hints.Length > 0 )
		return Hints[Rand(Hints.Length)];

	return "";
}

static function array<string> GetAllLoadHints(optional bool bThisClassOnly)
{
	local int i;
	local array<string> Hints;

	for ( i = 0; i < default.SiriusHints.Length; i++ )
		Hints[Hints.Length] = default.SiriusHints[i];

	return Hints;
}

State MatchInProgress
{
    function Timer()
    {
        local Controller P;

        Global.Timer();
		if ( !bFinalStartup )
		{
			bFinalStartup = true;
			PlayStartupMessage();
		}
        if ( bForceRespawn )
            For ( P=Level.ControllerList; P!=None; P=P.NextController )
            {
                if ( (P.Pawn == None) && P.IsA('PlayerController') && !P.PlayerReplicationInfo.bOnlySpectator )
                    PlayerController(P).ServerReStartPlayer();
            }
        if ( NeedPlayers() && AddBot() && (RemainingBots > 0) )
			RemainingBots--;

        ElapsedTime++;
        GameReplicationInfo.ElapsedTime = ElapsedTime;
    }

    function beginstate()
    {
		local PlayerReplicationInfo PRI;

		ForEach DynamicActors(class'PlayerReplicationInfo',PRI)
			PRI.StartTime = 0;
		ElapsedTime = 0;
		bWaitingToStartMatch = false;
        StartupStage = 5;
        PlayStartupMessage();
        StartupStage = 6;
    }
}

defaultproperties
{
	bQuickStart=true
	BotMode=1
	DefaultPlayerClassName="zwolf.Remmy"
	PlayerControllerClassName="zwolf.RemmyController"
	HUDType="zwolf.HUDSirius"
	MapListType="zwolf.MapListSirius"
	MapPrefix="Sirius"
	GameName="Sirius"
	DefaultPlayerName="Remmy"
	bAutoNumBots=0
	bPlayersMustBeReady=false
	RestartWait=0
	CountDown=0
	RemainingTime=0
	TimeLimit=0
	EndGameSound(0)=Sound'zwolf.Mission.MissionAccomplished'
	EndGameSound(1)=Sound'zwolf.Mission.MissionFailed'
	Description="A plague is spreading through the city of Arcas and Remmy needs to escape the city because he is being suspected of infection."DMHints(0)="Every weapon has two firing modes, a regular fire mode when you press %FIRE% and an alternate fire mode when you press %ALTFIRE%."
	SiriusHints(1)="You can make an extra jump while in mid-air."
	SiriusHints(2)="While in the air, you can make a dash by tapping the direction keys twice rapidly."
	SiriusHints(3)="You can dodge off a wall in mid-air by pushing towards a wall and pressing the jump key."
	SiriusHints(4)="Your freeze ray has a slow recharge rate but it can keep an enemy in place for a long time."
	SiriusHints(5)="You can stand on top of enemies that you have immobilized with the freeze ray."
	SiriusHints(6)="Your alternate fire is the breath blowback where enemies are pushed away from you."
	SiriusHints(7)="You can use the breath on a frozen enemy to move them around."
	SiriusHints(8)="You can play taunts or other voice messages through the voice menu by pressing %SPEECHMENUTOGGLE%."
	SiriusHints(9)="While crouching (by holding down %DUCK%), you cannot fall off a ledge."
}
